/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.NormalDistribution;

public class OrnsteinUhlenbeck
implements GenerativeDistribution<Double> {
    protected Value<Double> y0;
    protected Value<Double> time;
    protected Value<Double> diffRate;
    protected Value<Double> theta;
    protected Value<Double> alpha;
    public static final String y0ParamName = "y0";
    public static final String timeParamName = "time";
    public static final String diffRateParamName = "diffRate";
    public static final String thetaParamName = "theta";

    public OrnsteinUhlenbeck(@ParameterInfo(name="y0", description="the initial value of the continuous trait.") Value<Double> y0, @ParameterInfo(name="time", description="the time since the initial value.") Value<Double> time, @ParameterInfo(name="diffRate", description="the variance of the underlying Brownian process. This is not the equilibrium variance of the OU process.") Value<Double> diffRate, @ParameterInfo(name="theta", description="the 'optimal' value that the long-term process is centered around.") Value<Double> theta, @ParameterInfo(name="alpha", description="the drift term that determines the rate of drift towards the optimal value.") Value<Double> alpha) {
        this.y0 = y0;
        this.time = time;
        this.diffRate = diffRate;
        this.theta = theta;
        this.alpha = alpha;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(OrnsteinUhlenbeck.y0ParamName, OrnsteinUhlenbeck.this.y0);
                this.put(OrnsteinUhlenbeck.timeParamName, OrnsteinUhlenbeck.this.time);
                this.put(OrnsteinUhlenbeck.diffRateParamName, OrnsteinUhlenbeck.this.diffRate);
                this.put(OrnsteinUhlenbeck.thetaParamName, OrnsteinUhlenbeck.this.theta);
                this.put("alpha", OrnsteinUhlenbeck.this.alpha);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "y0": {
                this.y0 = value;
                break;
            }
            case "time": {
                this.time = value;
                break;
            }
            case "diffRate": {
                this.diffRate = value;
                break;
            }
            case "theta": {
                this.theta = value;
                break;
            }
            case "alpha": {
                this.alpha = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    @Override
    public RandomVariable<Double> sample() {
        return new RandomVariable<Double>(null, Double.valueOf(this.sampleNewState(this.y0.value(), this.time.value())), this);
    }

    protected double sampleNewState(double initialState, double time) {
        double th = this.theta.value();
        double a = this.alpha.value();
        double v = this.diffRate.value() / (2.0 * a);
        double weight = Math.exp(-a * time);
        double mean = (1.0 - weight) * th + weight * initialState;
        double variance = v * (1.0 - Math.exp(-2.0 * a * time));
        NormalDistribution distribution = new NormalDistribution(Utils.getRandom(), mean, Math.sqrt(variance));
        return this.handleBoundaries(distribution.sample());
    }

    protected double handleBoundaries(double rawValue) {
        return rawValue;
    }
}

