/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.PoissonDistribution;

public class Poisson
implements GenerativeDistribution1D<Integer> {
    private static final String lambdaParamName = "lambda";
    private static final String offsetParamName = "offset";
    private static final String minParamName = "min";
    private static final String maxParamName = "max";
    private Value<Number> lambda;
    private Value<Integer> min;
    private Value<Integer> max;
    private Value<Integer> offset;
    static final int MAX_TRIES = 10000;
    private static final Integer[] domainBounds = new Integer[]{0, Integer.MAX_VALUE};

    public Poisson(@ParameterInfo(name="lambda", description="the expected number of events.") Value<Number> lambda, @ParameterInfo(name="offset", optional=true, description="optional parameter to add a constant to the returned result. default is 0") Value<Integer> offset, @ParameterInfo(name="min", optional=true, description="optional parameter to specify a condition that the number of events must be greater than or equal to this mininum") Value<Integer> min, @ParameterInfo(name="max", optional=true, description="optional parameter to specify a condition that the number of events must be less than or equal to this maximum") Value<Integer> max) {
        this.lambda = lambda;
        this.min = min;
        this.max = max;
        this.offset = offset;
    }

    @Override
    @GeneratorInfo(name="Poisson", description="The probability distribution of the number of events when the expected number of events is lambda, supported on the set { 0, 1, 2, 3, ... }.")
    public RandomVariable<Integer> sample() {
        PoissonDistribution poisson = new PoissonDistribution(ValueUtils.doubleValue(this.lambda));
        int minimum = this.min();
        int maximum = this.max();
        int val = -1;
        int count = 0;
        while (val < minimum || val > maximum) {
            val = poisson.sample() + this.C();
            if (++count <= 10000) continue;
            throw new RuntimeException("Failed to draw conditional Poisson random variable after 10000 attempts.");
        }
        return new RandomVariable<Integer>(null, Integer.valueOf(val), this);
    }

    private int C() {
        int C = 0;
        if (this.offset != null) {
            C = this.offset.value();
        }
        return C;
    }

    private int min() {
        if (this.min != null) {
            return this.min.value();
        }
        return 0;
    }

    private int max() {
        if (this.max != null) {
            return this.max.value();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public double density(Integer i) {
        PoissonDistribution poisson = new PoissonDistribution(ValueUtils.doubleValue(this.lambda));
        if (i < this.min()) {
            return 0.0;
        }
        if (i > this.max()) {
            return 0.0;
        }
        return poisson.probability(i - this.C());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(Poisson.lambdaParamName, Poisson.this.lambda);
                if (Poisson.this.min != null) {
                    this.put(Poisson.minParamName, Poisson.this.min);
                }
                if (Poisson.this.max != null) {
                    this.put(Poisson.maxParamName, Poisson.this.max);
                }
                if (Poisson.this.offset != null) {
                    this.put(Poisson.offsetParamName, Poisson.this.offset);
                }
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "lambda": {
                this.lambda = value;
                break;
            }
            case "min": {
                this.min = value;
                break;
            }
            case "max": {
                this.max = value;
                break;
            }
            case "offset": {
                this.offset = value;
                break;
            }
            default: {
                throw new RuntimeException("The valid parameter names are lambda, min, max and offset");
            }
        }
    }

    public void setLambda(double p) {
        this.lambda.setValue(p);
    }

    public String toString() {
        return this.getName();
    }

    public Integer[] getDomainBounds() {
        return domainBounds;
    }

    public Value<Number> getLambda() {
        return this.lambda;
    }

    public Value<Integer> getMin() {
        return this.min;
    }

    public Value<Integer> getMax() {
        return this.max;
    }

    public Value<Integer> getOffset() {
        return this.offset;
    }
}

