/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class RandomBooleanArray
implements GenerativeDistribution<Boolean[]> {
    private static final String lengthParamName = "length";
    private static final String hammingWeightParamName = "hammingWeight";
    private Value<Integer> length;
    private Value<Integer> hammingWeight;

    public RandomBooleanArray(@ParameterInfo(name="length", description="the length of the boolean array to be generated.") Value<Integer> length, @ParameterInfo(name="hammingWeight", description="the number of true values in the boolean array.") Value<Integer> hammingWeight) {
        this.length = length;
        this.hammingWeight = hammingWeight;
    }

    @Override
    @GeneratorInfo(name="RandomBooleanArray", description="Samples a random boolean array of given length and given hamming weight. The hamming weight is the number of true values in the array and must be less than or equal to the length.")
    public RandomVariable<Boolean[]> sample() {
        ArrayList<Boolean> bools = new ArrayList<Boolean>();
        int weight = this.hammingWeight.value();
        if (weight > this.length.value()) {
            weight = this.length.value();
            System.err.println("WARNING: hammingWeight was greater than length in " + this.getClass().getSimpleName() + "! Will produce an array of true values.");
        }
        for (int i = 0; i < weight; ++i) {
            bools.add(true);
        }
        while (bools.size() < this.length.value()) {
            bools.add(false);
        }
        Collections.shuffle(bools);
        Boolean[] array = new Boolean[bools.size()];
        return new RandomVariable<Boolean[]>("x", bools.toArray(array), this);
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(RandomBooleanArray.lengthParamName, RandomBooleanArray.this.length);
                this.put(RandomBooleanArray.hammingWeightParamName, RandomBooleanArray.this.hammingWeight);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals(lengthParamName)) {
            this.length = value;
        } else if (paramName.equals(hammingWeightParamName)) {
            this.hammingWeight = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }
}

