/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class RandomComposition
implements GenerativeDistribution<Integer[]> {
    private static final String kParamName = "k";
    private Value<Integer> n;
    private Value<Integer> k;

    public RandomComposition(@ParameterInfo(name="n", description="the sum of the random tuple.") Value<Integer> n, @ParameterInfo(name="k", description="the size of the random tuple.") Value<Integer> k) {
        this.n = n;
        this.k = k;
    }

    @Override
    @GeneratorInfo(name="RandomComposition", description="Samples a random k-tuple of positive integers that sum to n.")
    public RandomVariable<Integer[]> sample() {
        ArrayList<Integer> bars = new ArrayList<Integer>();
        RandomGenerator random = Utils.getRandom();
        bars.add(0);
        while (bars.size() < this.k.value()) {
            int candidate = random.nextInt(this.n.value() - 1) + 1;
            if (bars.contains(candidate)) continue;
            bars.add(candidate);
        }
        bars.add(this.n.value());
        Collections.sort(bars);
        Integer[] composition = new Integer[this.k.value().intValue()];
        for (int i = 0; i < composition.length; ++i) {
            composition[i] = (Integer)bars.get(i + 1) - (Integer)bars.get(i);
        }
        return new RandomVariable<Integer[]>("x", composition, this);
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("n", RandomComposition.this.n);
                this.put(RandomComposition.kParamName, RandomComposition.this.k);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("n")) {
            this.n = value;
        } else if (paramName.equals(kParamName)) {
            this.k = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }
}

