/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class Uniform
implements GenerativeDistribution<Double> {
    private Value<Number> lower;
    private Value<Number> upper;
    private RandomGenerator random;

    public Uniform(@ParameterInfo(name="lower", description="the lower bound of the uniform distribution.") Value<Number> lower, @ParameterInfo(name="upper", description="the upper bound of the uniform distribution.") Value<Number> upper) {
        this.lower = lower;
        this.upper = upper;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Uniform", description="The uniform probability distribution.")
    public RandomVariable<Double> sample() {
        double l = ValueUtils.doubleValue(this.lower);
        double u = ValueUtils.doubleValue(this.upper);
        double x = this.random.nextDouble() * (u - l) + l;
        return new RandomVariable<Double>(null, Double.valueOf(x), this);
    }

    @Override
    public double logDensity(Double x) {
        if (x < ValueUtils.doubleValue(this.lower) || x > ValueUtils.doubleValue(this.upper)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(1.0) - Math.log(ValueUtils.doubleValue(this.upper) - ValueUtils.doubleValue(this.lower));
    }

    @Override
    public double density(Double x) {
        if (x < ValueUtils.doubleValue(this.lower) || x > ValueUtils.doubleValue(this.upper)) {
            return 0.0;
        }
        return 1.0 / (ValueUtils.doubleValue(this.upper) - ValueUtils.doubleValue(this.lower));
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("lower", Uniform.this.lower);
                this.put("upper", Uniform.this.upper);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("lower")) {
            this.lower = value;
        } else if (paramName.equals("upper")) {
            this.upper = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Number> getLower() {
        return this.lower;
    }

    public Value<Number> getUpper() {
        return this.upper;
    }
}

