/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Beta;
import lphy.core.distributions.IID;
import lphy.core.functions.VectorizedFunction;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.CompoundVector;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.SliceValue;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.VectorUtils;
import lphy.graphicalModel.VectorizedRandomVariable;

public class VectorizedDistribution<T>
implements GenerativeDistribution<T[]> {
    Map<String, Value> params;
    Map<String, Class> baseTypes = new TreeMap<String, Class>();
    List<GenerativeDistribution<T>> componentDistributions;

    public VectorizedDistribution(Constructor baseDistributionConstructor, List<Argument> arguments, Object[] vectorArgs) {
        this.params = Generator.convertArgumentsToParameterMap(arguments, vectorArgs);
        try {
            int size = VectorUtils.getVectorSize(arguments, vectorArgs);
            this.componentDistributions = new ArrayList<GenerativeDistribution<T>>(size);
            for (int component = 0; component < size; ++component) {
                this.componentDistributions.add((GenerativeDistribution)VectorUtils.getComponentGenerator(baseDistributionConstructor, arguments, vectorArgs, component));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        this.componentDistributions.get(0).getParams().forEach((key, value) -> {
            if (value != null) {
                this.baseTypes.put((String)key, value.getType());
            }
        });
    }

    @Override
    public String getInferenceStatement(Value value, Narrative narrative) {
        if (value instanceof VectorizedRandomVariable) {
            VectorizedRandomVariable vrv = (VectorizedRandomVariable)value;
            StringBuilder builder = new StringBuilder();
            builder.append(narrative.product("i", "0", this.getTo(vrv, narrative)));
            Generator generator = this.componentDistributions.get(0);
            Value v = vrv.getComponentValue(0);
            String componentStatement = generator.getInferenceStatement(v, narrative);
            componentStatement = componentStatement.replaceAll("_0", narrative.subscript("i"));
            componentStatement = componentStatement.replaceAll("_\\{0}", narrative.subscript("i"));
            builder.append(componentStatement);
            return builder.toString();
        }
        throw new RuntimeException("Expected VectorizedRandomVariable!");
    }

    public Value getReplicatesValue() {
        for (Map.Entry<String, Value> entry : this.getParams().entrySet()) {
            Value replicatesValue;
            Generator paramGenerator = entry.getValue().getGenerator();
            if (paramGenerator == null || !this.isVectorizedParameter(entry.getKey())) continue;
            if (paramGenerator instanceof IID) {
                return ((IID)entry.getValue().getGenerator()).getReplicates();
            }
            if (paramGenerator instanceof VectorizedDistribution) {
                replicatesValue = ((VectorizedDistribution)paramGenerator).getReplicatesValue();
                if (replicatesValue == null) continue;
                return replicatesValue;
            }
            if (paramGenerator instanceof VectorizedFunction) {
                replicatesValue = ((VectorizedFunction)paramGenerator).getReplicatesValue();
                if (replicatesValue == null) continue;
                return replicatesValue;
            }
            VectorUtils.getReplicatesValue(paramGenerator, this.componentDistributions.size());
        }
        return null;
    }

    public boolean isVectorizedParameter(String paramName) {
        return VectorUtils.isVectorizedParameter(paramName, this.getParams().get(paramName), this.baseTypes);
    }

    private String getTo(VectorizedRandomVariable value, Narrative narrative) {
        Value replicatesValue = this.getReplicatesValue();
        if (replicatesValue != null) {
            return narrative.getId(replicatesValue, false) + " - 1";
        }
        return "" + (value.size() - 1);
    }

    @Override
    public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        if (value instanceof VectorizedRandomVariable) {
            VectorizedRandomVariable vrv = (VectorizedRandomVariable)value;
            StringBuilder builder = new StringBuilder();
            Generator generator = this.componentDistributions.get(0);
            Value v = vrv.getComponentValue(0);
            String inferenceNarrative = generator.getInferenceNarrative(v, unique, narrative);
            inferenceNarrative = inferenceNarrative.replace(narrative.subscript("0"), narrative.subscript("i"));
            builder.append(inferenceNarrative);
            return builder.toString();
        }
        throw new RuntimeException("Expected VectorizedRandomVariable!");
    }

    @Override
    public String getNarrativeName(Value value) {
        String paramName = this.getParamName(value);
        Generator generator = this.componentDistributions.get(0);
        return generator.getNarrativeName(paramName);
    }

    public GenerativeDistribution<T> getBaseDistribution(int component) {
        return this.componentDistributions.get(component);
    }

    public List<GenerativeDistribution<T>> getComponentDistributions() {
        return this.componentDistributions;
    }

    @Override
    public RandomVariable<T[]> sample() {
        int vectorSize = VectorUtils.getVectorSize(this.params, this.baseTypes);
        ArrayList<RandomVariable> componentVariables = new ArrayList<RandomVariable>();
        for (int i = 0; i < vectorSize; ++i) {
            componentVariables.add(this.getBaseDistribution(i).sample());
        }
        return new VectorizedRandomVariable(null, (List<RandomVariable>)componentVariables, this);
    }

    @Override
    public Map<String, Value> getParams() {
        return this.params;
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.params.put(paramName, value);
        if (!VectorUtils.isVectorizedParameter(paramName, value, this.baseTypes)) {
            for (GenerativeDistribution<T> baseDistribution : this.componentDistributions) {
                baseDistribution.setParam(paramName, value);
            }
        } else {
            for (int i = 0; i < this.componentDistributions.size(); ++i) {
                if (value instanceof CompoundVector) {
                    Value componentValue = ((CompoundVector)((Object)value)).getComponentValue(i);
                    if (componentValue.isAnonymous()) {
                        componentValue.setId(paramName + "_" + i);
                    }
                    this.componentDistributions.get(i).setInput(paramName, componentValue);
                    continue;
                }
                SliceValue sv = new SliceValue(i, value);
                this.componentDistributions.get(i).setInput(paramName, sv);
            }
        }
    }

    @Override
    public String getTypeName() {
        if (this.componentDistributions.size() > 1) {
            return "vector of " + NarrativeUtils.pluralize(this.componentDistributions.get(0).getTypeName());
        }
        return Generator.getReturnType(this.getClass()).getSimpleName();
    }

    @Override
    public String getRichDescription(int index) {
        return this.componentDistributions.get(0).getRichDescription(0);
    }

    @Override
    public String getName() {
        return this.componentDistributions.get(0).getName();
    }

    public static void main(String[] args) {
        Value<Number> a = new Value<Number>("alpha", 2.0);
        Value<Number> b = new Value<Number>("beta", 2.0);
        Beta beta = new Beta(a, b);
        HashMap<String, Value<Object>> params = new HashMap<String, Value<Object>>();
        params.put("alpha", new Value<Double[]>("alpha", new Double[]{200.0, 200.0, 200.0, 3.0, 3.0, 3.0}));
        params.put("beta", new Value<Double>("beta", 2.0));
        Object[] initArgs = new Object[]{params.get("alpha"), params.get("beta")};
        Constructor<?> constructor = beta.getClass().getConstructors()[0];
        VectorizedDistribution v = new VectorizedDistribution(constructor, Generator.getArguments(constructor), initArgs);
        RandomVariable<T[]> rbeta = v.sample();
        System.out.println(Arrays.toString((Object[])rbeta.value()));
    }
}

