/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;

public class Weibull
implements GenerativeDistribution<Double> {
    private Value<Double> alpha;
    private Value<Double> beta;

    public Weibull(@ParameterInfo(name="alpha", description="the first shape parameter of the Weibull distribution.") Value<Double> alpha, @ParameterInfo(name="beta", description="the second shape parameter of the Weibull distribution.") Value<Double> beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    @GeneratorInfo(name="Weibull", description="The Weibull distribution.")
    public RandomVariable<Double> sample() {
        WeibullDistribution weibullDistribution = new WeibullDistribution(this.alpha.value().doubleValue(), this.beta.value().doubleValue());
        double randomVariable = weibullDistribution.sample();
        return new RandomVariable<Double>("x", Double.valueOf(randomVariable), this);
    }

    @Override
    public double logDensity(Double d) {
        BetaDistribution betaDistribution = new BetaDistribution(this.alpha.value().doubleValue(), this.beta.value().doubleValue());
        return betaDistribution.logDensity(d.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("alpha", Weibull.this.alpha);
                this.put("beta", Weibull.this.beta);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("alpha")) {
            this.alpha = value;
        } else if (paramName.equals("beta")) {
            this.beta = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }
}

