/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class WeightedDirichlet
implements GenerativeDistribution<Double[]> {
    public static final String weightsParamName = "weights";
    private Value<Number[]> concentration;
    private Value<Integer[]> weights;

    public WeightedDirichlet(@ParameterInfo(name="conc", narrativeName="concentration", description="the concentration parameters of the scaled Dirichlet distribution.") Value<Number[]> concentration, @ParameterInfo(name="weights", description="the weight parameters of the scaled Dirichlet distribution.") Value<Integer[]> weights) {
        this.concentration = concentration;
        this.weights = weights;
    }

    @Override
    @GeneratorInfo(name="WeightedDirichlet", description="The scaled dirichlet probability distribution.")
    public RandomVariable<Double[]> sample() {
        int i;
        Number[] weight = this.weights.value();
        Number[] conc = this.concentration.value();
        double weightsum = 0.0;
        for (int i2 = 0; i2 < weight.length; ++i2) {
            weightsum += weight[i2].doubleValue();
        }
        Double[] z = new Double[this.concentration.value().length];
        double sum = 0.0;
        for (i = 0; i < z.length; ++i) {
            double val = Utils.randomGamma(conc[i].doubleValue(), 1.0);
            z[i] = val;
            sum += val * (weight[i].doubleValue() / weightsum);
        }
        i = 0;
        while (i < z.length) {
            Double[] doubleArray = z;
            int n = i++;
            Double.valueOf(doubleArray[n] / sum);
        }
        return new RandomVariable<Double[]>(null, z, this);
    }

    @Override
    public double density(Double d) {
        return 0.0;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("conc", WeightedDirichlet.this.concentration);
                this.put(WeightedDirichlet.weightsParamName, WeightedDirichlet.this.weights);
            }
        };
    }

    public Value<Number[]> getConcentration() {
        return this.concentration;
    }

    public Value<Integer[]> getWeights() {
        return this.weights;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("conc")) {
            this.concentration = value;
        } else if (paramName.equals(weightsParamName)) {
            this.weights = value;
        } else {
            throw new RuntimeException("Only valid parameter name is conc");
        }
    }

    public String toString() {
        return this.getName();
    }
}

