/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class ARange
extends DeterministicFunction<Double[]> {
    String startParamName = this.getParamName(0);
    String stopParamName = this.getParamName(1);
    String stepParamName = this.getParamName(2);

    public ARange(@ParameterInfo(name="start", description="value of the range to start at (inclusive)") Value<Double> start, @ParameterInfo(name="stop", description="value of the range to stop at (inclusive)") Value<Double> stop, @ParameterInfo(name="step", description="the step size") Value<Double> step) {
        this.setParam(this.startParamName, (Value)start);
        this.setParam(this.stopParamName, (Value)stop);
        this.setParam(this.startParamName, (Value)step);
    }

    @Override
    @GeneratorInfo(name="arange", description="A function to produce an equally space array of doubles. Takes a start value, and stop value and a step value and returns a double array value.")
    public Value<Double[]> apply() {
        double s = this.start().value();
        double e = this.stop().value();
        double t = this.step().value();
        int len = (int)Math.floor((e - s) / t) + 1;
        Double[] sequence = new Double[len];
        int c = 0;
        for (double i = s; i <= e; i += t) {
            sequence[c] = i;
            ++c;
        }
        return new Value<Double[]>(null, sequence, this);
    }

    public Value<Double> start() {
        return (Value)this.paramMap.get(this.startParamName);
    }

    public Value<Double> stop() {
        return (Value)this.paramMap.get(this.stopParamName);
    }

    public Value<Double> step() {
        return (Value)this.paramMap.get(this.stepParamName);
    }
}

