/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class ArgI
extends DeterministicFunction<Integer> {
    private static final String nameParamName = "name";
    private static final String defaultParamName = "default";
    private Value<String> name;
    private Value<Integer> defaultValue;
    private static Map<String, Integer> integerArguments = new TreeMap<String, Integer>();

    public ArgI(@ParameterInfo(name="name", description="the name of the integer argument.") Value<String> name, @ParameterInfo(name="default", description="the default value.", optional=true) Value<Integer> defaultValue) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("The mean value can't be null!");
        }
        this.defaultValue = defaultValue;
    }

    @Override
    @GeneratorInfo(name="argi", description="The arg function for reading an integer.")
    public Value<Integer> apply() {
        Integer value = integerArguments.get(this.name.value());
        if (value != null) {
            return new Value<Integer>(value, this);
        }
        return this.defaultValue;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(ArgI.nameParamName, ArgI.this.name);
                this.put(ArgI.defaultParamName, ArgI.this.defaultValue);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals(nameParamName)) {
            this.name = value;
        } else if (paramName.equals(defaultParamName)) {
            this.defaultValue = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public static void putArgument(String name, int value) {
        integerArguments.put(name, value);
    }
}

