/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.Value;

public class ArrayFunction
extends DeterministicFunction<Object[]> {
    Value<Object>[] x;

    public ArrayFunction(Value<Object> ... x) {
        int length = x.length;
        this.x = x;
        for (int i = 0; i < length; ++i) {
            this.setInput("" + i, x[i]);
        }
    }

    @Override
    @GeneratorInfo(name="array", description="The constructor function for an array of values.")
    public Value<Object[]> apply() {
        Object[] values = new Object[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            values[i] = this.x[i].value();
        }
        return new Value<Object[]>(null, values, this);
    }

    @Override
    public void setParam(String param, Value value) {
        super.setParam(param, value);
        int i = Integer.parseInt(param);
        this.x[i] = value;
    }

    @Override
    public String codeString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.ref(this.x[0]));
        for (int i = 1; i < this.x.length; ++i) {
            builder.append(", ");
            builder.append(this.ref(this.x[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    private String ref(Value<?> val) {
        if (val.isAnonymous()) {
            return val.codeString();
        }
        return val.getId();
    }
}

