/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class BinaryRateMatrix
extends DeterministicFunction<Double[][]> {
    public static final String lambdaParamName = "lambda";

    public BinaryRateMatrix(@ParameterInfo(name="lambda", description="the lambda parameter of the binary process. Rate of 0->1 is 1, rate of 1->0 is lambda.") Value<Number> lambda) {
        this.setParam(lambdaParamName, (Value)lambda);
    }

    @Override
    @GeneratorInfo(name="binaryRateMatrix", description="The binary trait instantaneous rate matrix. Takes a lambda and produces an instantaneous rate matrix:\n\n    Q = \u23a1-1  1\u23a4\n        \u23a3 \u03bb -\u03bb\u23a6")
    public Value<Double[][]> apply() {
        Value lambda = this.getParams().get(lambdaParamName);
        return new DoubleArray2DValue(this.binaryCTMC(ValueUtils.doubleValue(lambda)), (DeterministicFunction)this);
    }

    private Double[][] binaryCTMC(double lambda) {
        Double[][] Q = new Double[][]{{-1.0, 1.0}, {lambda, -lambda}};
        double[] freqs = new double[]{lambda / (lambda + 1.0), 1.0 / (lambda + 1.0)};
        double[] rate = new double[]{1.0, lambda};
        double subst = rate[0] * freqs[0] + rate[1] * freqs[1];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Q[i][j] = Q[i][j] / subst;
            }
        }
        return Q;
    }
}

