/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.util.Map;
import java.util.TreeMap;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class CoalescentCorrection
extends DeterministicFunction<Double[][]> {
    private final String treeParamName;
    private final String thetaParamName;
    private Value<TimeTree> speciesTree;
    private Value<Double[]> theta;

    public CoalescentCorrection(@ParameterInfo(name="speciesTree", description="the species tree.") Value<TimeTree> speciesTree, @ParameterInfo(name="populationSizes", description="the population sizes for each branch of the species tree.") Value<Double[]> theta) {
        this.speciesTree = speciesTree;
        this.theta = theta;
        if (speciesTree.value().n() * 2 - 1 != theta.value().length) {
            throw new RuntimeException("Must have one population size for each branch of species tree.");
        }
        this.treeParamName = this.getParamName(0);
        this.thetaParamName = this.getParamName(1);
    }

    @Override
    @GeneratorInfo(name="coalescentCorrection", description="Constructs the expected variance-covariance matrix of a gene tree from given species tree and population sizes.")
    public Value<Double[][]> apply() {
        return null;
    }

    @Override
    public Map<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put(this.treeParamName, this.speciesTree);
        map.put(this.thetaParamName, this.theta);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals(this.treeParamName)) {
            this.speciesTree = value;
        } else if (paramName.equals(this.thetaParamName)) {
            this.theta = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }
}

