/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.util.Objects;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class Concat
extends DeterministicFunction {
    public static final String firstParamName = "prefix";
    public static final String secondParamName = "suffix";

    public Concat(@ParameterInfo(name="prefix", description="the prefix substring to concatenate.") Value<String> substr1, @ParameterInfo(name="suffix", description="the suffix substring to concatenate.") Value<String> substr2) {
        this.setInput(firstParamName, substr1);
        this.setInput(secondParamName, substr2);
    }

    @GeneratorInfo(name="concat", description="A function to concatenate substrings into one sting.")
    public Value<String> apply() {
        Value substr1 = this.getParams().get(firstParamName);
        Value substr2 = this.getParams().get(secondParamName);
        return this.join(substr1, substr2);
    }

    private Value<String> join(Value<String> ... substr) {
        StringBuilder oneStr = new StringBuilder();
        for (Value<String> s : substr) {
            oneStr.append(Objects.requireNonNull(s).value());
        }
        return new Value<String>(oneStr.toString(), this);
    }
}

