/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Array;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class CreateTaxa
extends DeterministicFunction<Taxa> {
    public static final String taxaParamName = "names";
    public static final String speciesParamName = "species";
    public static final String agesParamName = "ages";

    public CreateTaxa(@ParameterInfo(name="names", description="an array of objects representing taxa names") Value taxaNames, @ParameterInfo(name="species", description="an array of objects representing species names", optional=true) Value<Object[]> species, @ParameterInfo(name="ages", description="the ages of the taxa", optional=true) Value<Double[]> ages) {
        this.setParam(taxaParamName, taxaNames);
        if (species != null) {
            this.setParam(speciesParamName, (Value)species);
        }
        if (ages != null) {
            this.setParam(agesParamName, (Value)ages);
        }
    }

    @Override
    @GeneratorInfo(name="taxa", description="A set of taxa with species and ages defined in parallel arrays.")
    public Value<Taxa> apply() {
        Value names = this.getParams().get(taxaParamName);
        Value speciesValue = this.getParams().get(speciesParamName);
        Value agesValue = this.getParams().get(agesParamName);
        if (names.value().getClass().isArray()) {
            if (speciesValue == null || speciesValue.value().getClass().isArray()) {
                Taxon[] taxonArray = new Taxon[Array.getLength(names.value())];
                for (int i = 0; i < taxonArray.length; ++i) {
                    String name = Array.get(names.value(), i).toString();
                    String species = null;
                    if (speciesValue != null) {
                        species = Array.get(speciesValue.value(), i).toString();
                    }
                    double age = 0.0;
                    if (agesValue != null) {
                        age = ((Double[])agesValue.value())[i];
                    }
                    taxonArray[i] = new Taxon(name, species, age);
                }
                Taxa.Simple taxa = new Taxa.Simple(taxonArray);
                return new Value<Taxa>(null, taxa, this);
            }
            throw new IllegalArgumentException("species must be an array.");
        }
        throw new IllegalArgumentException("names must be an array.");
    }
}

