/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Array;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class ElementsAt<T>
extends DeterministicFunction {
    public static final String indexParamName = "index";
    public static final String arrayParamName = "array";

    public ElementsAt(@ParameterInfo(name="index", description="index list") Value<Integer[]> i, @ParameterInfo(name="array", description="array to retrieve element of") Value<T[]> array) {
        this.setParam(indexParamName, (Value)i);
        this.setParam(arrayParamName, (Value)array);
    }

    @GeneratorInfo(name="elementsAt", description="A function to extract element(s) from an array by index.")
    public Value apply() {
        Value<T[]> array = this.array();
        Integer[] index = this.index().value();
        if (index.length > 1) {
            Object[] newArray = (Object[])Array.newInstance(array.value().getClass().getComponentType(), index.length);
            for (int i = 0; i < index.length; ++i) {
                newArray[i] = array.value()[index[i]];
            }
            return ValueUtils.createValue(newArray, (DeterministicFunction)this);
        }
        return ValueUtils.createValue(array.value()[index[0]], (DeterministicFunction)this);
    }

    public Value<T[]> array() {
        return (Value)this.paramMap.get(arrayParamName);
    }

    public Value<Integer[]> index() {
        return (Value)this.paramMap.get(indexParamName);
    }

    @Override
    public String codeString() {
        String arrayString = this.array().codeString();
        if (!this.array().isAnonymous()) {
            arrayString = this.array().getId();
        }
        Value<Integer[]> index = this.index();
        String indexString = null;
        indexString = index.isAnonymous() ? index.codeString() : index.getId();
        if (!this.index().isAnonymous()) {
            return super.codeString();
        }
        return arrayString + "[" + indexString + "]";
    }
}

