/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.DoubleValue;

public class Exp
extends DeterministicFunction<Double> {
    public static final String argParamName = "arg";

    public Exp(@ParameterInfo(name="arg", description="the argument.") Value<Number> x) {
        this.setParam(argParamName, (Value)x);
    }

    public Value<Double> apply(Value<Number> v) {
        this.setParam(argParamName, (Value)v);
        return new DoubleValue(null, Math.exp(ValueUtils.doubleValue(v)), this);
    }

    @Override
    @GeneratorInfo(name="exp", description="The exponential function: e^x")
    public Value<Double> apply() {
        return this.apply(this.getParams().get(argParamName));
    }
}

