/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.evolution.ExtractStringMetaData;
import lphy.evolution.Taxa;
import lphy.evolution.alignment.Alignment;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class ExtractTrait
extends DeterministicFunction<Alignment> {
    private final String taxaParamName = "taxa";
    private final String sepParamName = "sep";
    private final String indexParamName = "i";
    private final String traitNameParamName = "name";

    public ExtractTrait(@ParameterInfo(name="taxa", verb="from", description="the set of taxa whose names contain the traits.") Value<Taxa> taxa, @ParameterInfo(name="sep", description="the substring to split the taxa names, where Java regular expression escape characters will be given no special meaning.") Value<String> sepStr, @ParameterInfo(name="i", description="i (>=0) is the index to extract the trait value.") Value<Integer> index, @ParameterInfo(name="name", description="the map containing optional arguments and their values for reuse.", optional=true) Value<String> traitName) {
        this.setParam("taxa", (Value)taxa);
        this.setParam("sep", (Value)sepStr);
        this.setParam("i", (Value)index);
        if (traitName != null) {
            this.setParam("name", (Value)traitName);
        }
    }

    @Override
    @GeneratorInfo(name="extractTrait", verbClause="extracts", narrativeName="trait", description="return a trait alignment, which contains the set of traits extracted from taxa names.")
    public Value<Alignment> apply() {
        Taxa taxa = (Taxa)this.getParams().get("taxa").value();
        String sepStr = (String)this.getParams().get("sep").value();
        Integer index = (Integer)this.getParams().get("i").value();
        Value labelVal = this.getParams().get("name");
        String label = labelVal == null ? "" : labelVal.getUniqueId();
        ExtractStringMetaData metaData = new ExtractStringMetaData(label, sepStr, index);
        Alignment traitAlg = metaData.extractTraitAlignment(taxa);
        return new Value<Alignment>(null, traitAlg, this);
    }
}

