/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Array;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.IntegerValue;

public class Length
extends DeterministicFunction<Integer> {
    public static final String argParamName = "0";

    public Length(@ParameterInfo(name="0", verb="of", suppressNameInNarrative=true, description="the array to return the length of.") Value x) {
        this.setParam(argParamName, x);
    }

    @Override
    @GeneratorInfo(name="length", verbClause="is", description="the length of the argument")
    public Value<Integer> apply() {
        Value v = this.getParams().get(argParamName);
        Integer length = 1;
        if (v.value().getClass().isArray()) {
            length = Array.getLength(v.value());
        }
        return new IntegerValue(length, (DeterministicFunction)this);
    }
}

