/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.core.functions.newickParser.NewickASTVisitor;
import lphy.core.functions.newickParser.NewickLexer;
import lphy.core.functions.newickParser.NewickParser;
import lphy.core.functions.newickParser.TreeParsingException;
import lphy.evolution.Taxa;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.util.LoggerUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class Newick
extends DeterministicFunction<TimeTree> {
    public static final String treeParamName = "tree";

    public Newick(@ParameterInfo(name="tree", description="the tree in Newick format.") Value<String> x) {
        this.setParam(treeParamName, (Value)x);
    }

    @Override
    @GeneratorInfo(name="newick", description="A function that parses a tree from a newick formatted string.")
    public Value<TimeTree> apply() {
        Value newickValue = this.getParams().get(treeParamName);
        TimeTree tree = this.parseNewick((String)newickValue.value());
        return new Value<TimeTree>(tree, this);
    }

    private TimeTree parseNewick(String newick) {
        CodePointCharStream charStream = CharStreams.fromString((String)newick);
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new TreeParsingException(msg, charPositionInLine, line);
            }
        };
        NewickLexer lexer = new NewickLexer((CharStream)charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        NewickParser parser = new NewickParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        NewickParser.TreeContext parseTree = parser.tree();
        NewickASTVisitor visitor = new NewickASTVisitor();
        TimeTreeNode root = (TimeTreeNode)visitor.visit((ParseTree)parseTree);
        TimeTree tree = new TimeTree(Taxa.createTaxa(root));
        tree.setRoot(root);
        LoggerUtils.log.info("Parsed tree: " + tree);
        return tree;
    }
}

