/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleValue;

public class Pow
extends DeterministicFunction<Double> {
    String bparamName = this.getParamName(0);
    String xparamName = this.getParamName(1);

    public Pow(@ParameterInfo(name="0", description="the base.") Value<Double> b, @ParameterInfo(name="1", description="the exponent.") Value<Double> x) {
        this.setParam(this.bparamName, (Value)b);
        this.setParam(this.xparamName, (Value)x);
    }

    @Override
    @GeneratorInfo(name="pow", description="The power function: b^x")
    public Value<Double> apply() {
        Value b = this.getParams().get(this.bparamName);
        Value x = this.getParams().get(this.xparamName);
        return new DoubleValue(Math.pow((Double)b.value(), (Double)x.value()), this);
    }
}

