/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RangeElement;
import lphy.graphicalModel.Value;

public class Range
extends DeterministicFunction<Integer[]>
implements RangeElement {
    public static final String startParamName = "start";
    public static final String endParamName = "end";

    public Range(@ParameterInfo(name="start", description="start of the range (inclusive)") Value<Integer> start, @ParameterInfo(name="end", description="end of the range (inclusive)") Value<Integer> end) {
        this.setParam(endParamName, (Value)end);
        this.setParam(startParamName, (Value)start);
    }

    @Override
    public Value<Integer[]> apply() {
        int s = this.start().value();
        int e = this.end().value();
        Integer[] range = new Integer[e - s + 1];
        for (int i = s; i <= e; ++i) {
            range[i - s] = i;
        }
        return new Value<Integer[]>(null, range, this);
    }

    public Value<Integer> start() {
        return (Value)this.paramMap.get(startParamName);
    }

    public Value<Integer> end() {
        return (Value)this.paramMap.get(endParamName);
    }

    @Override
    public Integer[] range() {
        return (Integer[])this.value();
    }

    @Override
    public String codeString() {
        return this.start().codeString() + ":" + this.end().codeString();
    }
}

