/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jebl.evolution.io.FastaImporter;
import jebl.evolution.io.ImportException;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.evolution.alignment.Alignment;
import lphy.evolution.io.MetaDataAlignment;
import lphy.evolution.io.MetaDataOptions;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.util.IOUtils;
import lphy.util.LoggerUtils;

public class ReadFasta
extends DeterministicFunction<Alignment> {
    private final String fileParamName = "file";
    private final String optionsParamName = "options";

    public ReadFasta(@ParameterInfo(name="file", description="the name of fasta file.") Value<String> fileName, @ParameterInfo(name="options", description="the map containing optional arguments and their values for reuse.", optional=true) Value<Map<String, String>> options) {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name can't be null!");
        }
        this.setParam("file", (Value)fileName);
        if (options != null) {
            this.setParam("options", (Value)options);
        }
    }

    @Override
    @GeneratorInfo(name="readFasta", description="A function that parses an alignment from a Nexus file.")
    public Value<Alignment> apply() {
        String fileName = (String)this.getParams().get("file").value();
        Value optionsVal = this.getParams().get("options");
        String ageDirectionStr = MetaDataOptions.getAgeDirectionStr(optionsVal);
        String ageRegxStr = MetaDataOptions.getAgeRegxStr(optionsVal);
        String spRegxStr = MetaDataOptions.getSpecieseRegex(optionsVal);
        SequenceType sequenceType = SequenceType.NUCLEOTIDE;
        Path nexPath = IOUtils.getUserPath(fileName);
        Reader reader = this.getReader(nexPath.toString());
        List sequenceList = new ArrayList();
        try {
            FastaImporter fastaImporter = new FastaImporter(reader, sequenceType);
            sequenceList = fastaImporter.importSequences();
        }
        catch (IOException | ImportException e) {
            LoggerUtils.logStackTrace((Exception)e);
        }
        if (sequenceList.size() < 1) {
            throw new IllegalArgumentException("Fasta file has no sequence !");
        }
        Taxon[] taxons = new Taxon[sequenceList.size()];
        int siteCount = Objects.requireNonNull((Sequence)sequenceList.get(0)).getLength();
        for (int i = 0; i < sequenceList.size(); ++i) {
            Sequence s = (Sequence)sequenceList.get(i);
            jebl.evolution.taxa.Taxon t = s.getTaxon();
            taxons[i] = new Taxon(t.getName());
        }
        MetaDataAlignment faData = new MetaDataAlignment(Taxa.createTaxa(taxons), siteCount, sequenceType);
        for (int i = 0; i < sequenceList.size(); ++i) {
            Sequence sequence = (Sequence)sequenceList.get(i);
            for (int s = 0; s < sequence.getLength(); ++s) {
                State state = sequence.getState(s);
                int stateNum = state.getIndex();
                faData.setState(i, s, stateNum);
            }
        }
        if (ageRegxStr != null) {
            faData.setAgesFromTaxaName(ageRegxStr, ageDirectionStr);
        }
        if (spRegxStr != null) {
            faData.setSpeciesFromTaxaName(spRegxStr);
        }
        return new Value<Alignment>(null, faData, this);
    }

    private Reader getReader(String fileName) {
        BufferedReader reader = null;
        try {
            if (!(fileName.endsWith("fasta") || fileName.endsWith("fna") || fileName.endsWith("ffn") || fileName.endsWith("faa") || fileName.endsWith("frn"))) {
                throw new IOException("Fasta file name's suffix is invalid ! " + fileName);
            }
            Path nexFile = Paths.get(fileName, new String[0]);
            if (!nexFile.toFile().exists() || nexFile.toFile().isDirectory()) {
                throw new IOException("Cannot find Fasta file ! " + nexFile + ", user.dir = " + System.getProperty("user.dir"));
            }
            reader = Files.newBufferedReader(nexFile);
        }
        catch (IOException e) {
            LoggerUtils.logStackTrace(e);
        }
        return reader;
    }
}

