/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import jebl.evolution.io.ImportException;
import lphy.evolution.alignment.Alignment;
import lphy.evolution.io.MetaDataAlignment;
import lphy.evolution.io.MetaDataOptions;
import lphy.evolution.io.NexusParser;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.util.IOUtils;
import lphy.util.LoggerUtils;

public class ReadNexus
extends DeterministicFunction<Alignment> {
    private final String fileParamName = "file";
    private final String optionsParamName = "options";
    Value<String> fileName;
    Value<Map<String, String>> options;

    public ReadNexus(@ParameterInfo(name="file", narrativeName="file name", description="the name of Nexus file.") Value<String> fileName, @ParameterInfo(name="options", description="the map containing optional arguments and their values for reuse.", optional=true) Value<Map<String, String>> options) {
        this.fileName = fileName;
        this.options = options;
    }

    public SortedMap<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put("file", this.fileName);
        if (this.options != null) {
            map.put("options", this.options);
        }
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("file")) {
            this.fileName = value;
        } else if (paramName.equals("options")) {
            this.options = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    @Override
    @GeneratorInfo(name="readNexus", verbClause="is read from", narrativeName="Nexus file", description="A function that parses an alignment from a Nexus file.")
    public Value<Alignment> apply() {
        Path nexPath = IOUtils.getUserPath(this.fileName.value());
        NexusParser nexusParser = new NexusParser(nexPath.toString());
        String ageDirectionStr = MetaDataOptions.getAgeDirectionStr(this.options);
        String ageRegxStr = MetaDataOptions.getAgeRegxStr(this.options);
        String spRegxStr = MetaDataOptions.getSpecieseRegex(this.options);
        MetaDataAlignment nexusData = null;
        try {
            nexusData = nexusParser.importNexus(ageDirectionStr);
        }
        catch (IOException | ImportException e) {
            LoggerUtils.logStackTrace((Exception)e);
        }
        if (ageRegxStr != null) {
            if (!Objects.requireNonNull(nexusData).isUltrametric()) {
                LoggerUtils.log.severe("Taxa ages had been imported from the nexus file ! It would be problematic to overwrite taxa ages from the command line !");
            }
            nexusData.setAgesFromTaxaName(ageRegxStr, ageDirectionStr);
        }
        if (spRegxStr != null) {
            Objects.requireNonNull(nexusData).setSpeciesFromTaxaName(spRegxStr);
        }
        return new Value<Alignment>(null, nexusData, this);
    }
}

