/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class Rep<U>
extends DeterministicFunction<U[]> {
    private final String xParamName = "element";
    private final String timesParamName = "times";
    private Value<U> x;
    private Value<Integer> times;

    public Rep(@ParameterInfo(name="element", description="the element to replicate.") Value<U> x, @ParameterInfo(name="times", description="the standard deviation of the distribution.") Value<Integer> times) {
        this.x = x;
        if (x == null) {
            throw new IllegalArgumentException("The element can't be null!");
        }
        this.times = times;
        if (times == null) {
            throw new IllegalArgumentException("The times can't be null!");
        }
    }

    @GeneratorInfo(name="rep", description="The replication function. Takes a value and an integer representing the number of times to replicate the value. Returns a vector of the value repeated the specified number of times.")
    public Value<U[]> apply(Value<U> v, Value<Integer> times) {
        Class<?> c = v.value().getClass();
        Object[] array = (Object[])Array.newInstance(c, (int)times.value());
        Arrays.fill(array, v.value());
        return new Value<U[]>(array, this);
    }

    @Override
    public Map<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put("element", this.x);
        map.put("times", this.times);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("element")) {
            this.x = value;
        } else if (paramName.equals("times")) {
            this.times = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    @Override
    public Value<U[]> apply() {
        return this.apply(this.x, this.times);
    }
}

