/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class Select
extends DeterministicFunction<Number> {
    public static final String valueParamName = "x";
    public static final String indicatorParamName = "indicator";

    public Select(@ParameterInfo(name="x", description="the value.") Value<Number> x, @ParameterInfo(name="indicator", description="indicator for whether the number should be selected, or replace with zero") Value<Boolean> indicator) {
        this.setParam(valueParamName, (Value)x);
        this.setParam(indicatorParamName, (Value)indicator);
    }

    @Override
    @GeneratorInfo(name="select", description="A function to select a value if the indicator is true, or return 0 otherwise.")
    public Value<Number> apply() {
        Value<Number> x = this.getX();
        Boolean indicator = this.getIndicator().value();
        return ValueUtils.createValue(indicator != false ? (Number)x.value() : (Number)0.0, (DeterministicFunction)this);
    }

    public Value<Number> getX() {
        return (Value)this.paramMap.get(valueParamName);
    }

    public Value<Boolean> getIndicator() {
        return (Value)this.paramMap.get(indicatorParamName);
    }
}

