/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Array;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class Slice<T>
extends DeterministicFunction {
    public static final String startParamName = "start";
    public static final String endParamName = "end";
    public static final String arrayParamName = "array";

    public Slice(@ParameterInfo(name="start", description="start index") Value<Integer> start, @ParameterInfo(name="end", description="end index") Value<Integer> end, @ParameterInfo(name="array", description="array to retrieve element of") Value<T[]> array) {
        this.setInput(startParamName, start);
        this.setInput(endParamName, end);
        this.setInput(arrayParamName, array);
    }

    @GeneratorInfo(name="slice", description="A function to slice a subarray from an array.")
    public Value apply() {
        Value<T[]> array = this.array();
        Integer start = this.start().value();
        Integer end = this.end().value();
        if (end > start) {
            Object[] newArray = (Object[])Array.newInstance(array.value().getClass().getComponentType(), end - start + 1);
            for (int i = start.intValue(); i <= end; ++i) {
                newArray[i] = array.value()[i];
            }
            return ValueUtils.createValue(newArray, (DeterministicFunction)this);
        }
        return ValueUtils.createValue(array.value()[start], (DeterministicFunction)this);
    }

    public Value<T[]> array() {
        return (Value)this.paramMap.get(arrayParamName);
    }

    public Value<Integer> start() {
        return (Value)this.paramMap.get(startParamName);
    }

    public Value<Integer> end() {
        return (Value)this.paramMap.get(endParamName);
    }

    @Override
    public String codeString() {
        String arrayString = this.array().codeString();
        if (!this.array().isAnonymous()) {
            arrayString = this.array().getId();
        }
        String startString = this.start().codeString();
        String endString = this.end().codeString();
        if (!this.start().isAnonymous() || !this.end().isAnonymous()) {
            return super.codeString();
        }
        if (startString.equals(endString)) {
            return arrayString + "[" + startString + "]";
        }
        return arrayString + "[" + startString + ":" + endString + "]";
    }

    public int size() {
        return this.end().value() - this.start().value() + 1;
    }
}

