/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.util.ArrayList;
import lphy.evolution.Taxa;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class Species
extends DeterministicFunction<Taxa> {
    final String paramName = this.getParamName(0);

    public Species(@ParameterInfo(name="0", description="the taxa object from which to extract the species from.") Value<Taxa> taxa) {
        this.setParam(this.paramName, (Value)taxa);
    }

    @Override
    @GeneratorInfo(name="species", description="extract the species from the given taxa object as a new taxa object. Useful to generate a species tree in the multispecies coalescent. The age of each species will be the youngest age of the taxa from that species.")
    public Value<Taxa> apply() {
        Value taxa = this.getParams().get(this.paramName);
        Taxa tA = (Taxa)taxa.value();
        String[] species = tA.getSpecies();
        Double[] ages = tA.getAges();
        ArrayList<String> spTaxa = new ArrayList<String>();
        ArrayList<Double> spAges = new ArrayList<Double>();
        for (int i = 0; i < species.length; ++i) {
            if (!spTaxa.contains(species[i])) {
                spTaxa.add(species[i]);
                spAges.add(ages[i]);
                continue;
            }
            int index = spTaxa.indexOf(species[i]);
            if (!((Double)spAges.get(index) > ages[i])) continue;
            spAges.set(index, ages[i]);
        }
        final String[] speciesTaxaNames = spTaxa.toArray(new String[0]);
        final Double[] speciesAges = spAges.toArray(new Double[0]);
        Taxa speciesTaxa = new Taxa(){

            @Override
            public int getDimension() {
                return this.ntaxa();
            }

            @Override
            public Double[] getAges() {
                return speciesAges;
            }

            @Override
            public int ntaxa() {
                return speciesTaxaNames.length;
            }

            @Override
            public String[] getTaxaNames() {
                return speciesTaxaNames;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                for (int i = 0; i < speciesTaxaNames.length; ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(speciesTaxaNames[i]);
                    builder.append("=");
                    builder.append(speciesAges[i]);
                }
                builder.append("};");
                return builder.toString();
            }
        };
        return new Value<Taxa>(null, speciesTaxa, this);
    }
}

