/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.StringValue;

public class Split
extends DeterministicFunction<String> {
    public static final String stringParamName = "str";
    public static final String regexParamName = "regex";
    public static final String indexParamName = "i";

    public Split(@ParameterInfo(name="str", description="the string value to extract a substring matching the given pattern.") Value<String> str, @ParameterInfo(name="regex", description="a regular expression") Value<String> regex, @ParameterInfo(name="i", description="the index (>=0) of the substring to return") Value<Integer> i) {
        this.setParam(stringParamName, (Value)str);
        this.setParam(regexParamName, (Value)regex);
        this.setParam(indexParamName, (Value)i);
    }

    @Override
    @GeneratorInfo(name="split", description="A function to split a given string at the regular expressions and return the i'th (starting from 0) substring of the resulting list.")
    public Value<String> apply() {
        String str = this.getString().value();
        String regex = this.getRegex().value();
        int i = this.getI().value();
        String[] parts = str.split(regex);
        if (parts.length > i) {
            return new StringValue(null, parts[i], this);
        }
        return new StringValue(null, "", this);
    }

    public Value<String> getString() {
        return (Value)this.paramMap.get(stringParamName);
    }

    public Value<String> getRegex() {
        return (Value)this.paramMap.get(regexParamName);
    }

    public Value<Integer> getI() {
        return (Value)this.paramMap.get(indexParamName);
    }
}

