/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.IntegerValue;

public class SumBoolean
extends DeterministicFunction<Integer> {
    public static final String arrayParamName = "array";

    public SumBoolean(@ParameterInfo(name="array", description="the boolean array to sum the elements of.") Value<Boolean[]> x) {
        this.setParam(arrayParamName, (Value)x);
    }

    @Override
    @GeneratorInfo(name="hammingWeight", description="The sum of the true elements of the given boolean array")
    public Value<Integer> apply() {
        Boolean[] x = (Boolean[])this.getParams().get(arrayParamName).value();
        int sum = 0;
        for (Boolean i : x) {
            sum += i != false ? 1 : 0;
        }
        return new IntegerValue(sum, (DeterministicFunction)this);
    }
}

