/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import lphy.evolution.Taxa;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class TaxaAgesFromFunction
extends DeterministicFunction<Taxa> {
    public static final String paramName = "0";

    public TaxaAgesFromFunction(@ParameterInfo(name="0", description="the data containing taxa and ages of the taxa") Value<Taxa> taxaAgesValue) {
        this.setParam(paramName, (Value)taxaAgesValue);
    }

    @Override
    @GeneratorInfo(name="taxaAges", description="taxa and ages of the taxa.")
    public Value<Taxa> apply() {
        Value taxaAgesValue = this.getParams().get(paramName);
        Taxa tA = (Taxa)taxaAgesValue.value();
        final String[] taxa = tA.getTaxaNames();
        final Double[] ages = tA.getAges();
        Taxa taxaAges = new Taxa(){

            @Override
            public int getDimension() {
                return this.ntaxa();
            }

            @Override
            public Double[] getAges() {
                return ages;
            }

            @Override
            public int ntaxa() {
                return taxa.length;
            }

            @Override
            public String[] getTaxaNames() {
                return taxa;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                for (int i = 0; i < taxa.length; ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(taxa[i]);
                    builder.append("=");
                    builder.append(ages[i]);
                }
                builder.append("};");
                return builder.toString();
            }
        };
        return new Value<Taxa>(null, taxaAges, this);
    }
}

