/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.CompoundVectorValue;

public class Unique
extends DeterministicFunction<CompoundVectorValue> {
    public static final String argParamName = "arg";

    public Unique(@ParameterInfo(name="arg", verb="of", description="the string array to find its unique set.") Value<?> x) {
        this.setParam(argParamName, (Value)x);
    }

    @GeneratorInfo(name="unique", verbClause="provides", description="the unique set of the array")
    public CompoundVectorValue apply() {
        Value v = this.getParams().get(argParamName);
        LinkedHashSet uniqObj = new LinkedHashSet();
        ArrayList<Value> uniqVal = new ArrayList<Value>();
        if (v instanceof CompoundVectorValue) {
            CompoundVectorValue cvv = (CompoundVectorValue)v;
            for (int i = 0; i < cvv.size(); ++i) {
                Value val = cvv.getComponentValue(i);
                Object obj = Objects.requireNonNull(val).value();
                if (uniqObj.contains(obj)) continue;
                uniqObj.add(obj);
                uniqVal.add(val);
            }
        } else {
            throw new UnsupportedOperationException("Input requires an array or vector !");
        }
        return new CompoundVectorValue(null, (List<Value>)uniqVal, (DeterministicFunction)this);
    }
}

