/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.IID;
import lphy.core.distributions.VectorizedDistribution;
import lphy.core.functions.Exp;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.CompoundVector;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.Func;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.SliceValue;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.VectorUtils;
import lphy.graphicalModel.types.CompoundVectorValue;
import lphy.parser.ParserUtils;

public class VectorizedFunction<T>
extends DeterministicFunction<T[]> {
    Map<String, Value> params;
    Map<String, Class> baseTypes = new TreeMap<String, Class>();
    List<DeterministicFunction<T>> componentFunctions;

    public VectorizedFunction(Constructor baseDistributionConstructor, List<Argument> argInfo, Object[] vectorArgs) {
        this.params = Generator.convertArgumentsToParameterMap(argInfo, vectorArgs);
        try {
            int size = VectorUtils.getVectorSize(argInfo, vectorArgs);
            this.componentFunctions = new ArrayList<DeterministicFunction<T>>(size);
            for (int component = 0; component < size; ++component) {
                this.componentFunctions.add((DeterministicFunction)VectorUtils.getComponentGenerator(baseDistributionConstructor, argInfo, vectorArgs, component));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        this.componentFunctions.get(0).getParams().forEach((key, value) -> {
            if (value != null) {
                this.baseTypes.put((String)key, value.getType());
            }
        });
    }

    public DeterministicFunction<T> getComponentFunction(int component) {
        return this.componentFunctions.get(component);
    }

    @Override
    public Value<T[]> apply() {
        int vectorSize = VectorUtils.getVectorSize(this.params, this.baseTypes);
        ArrayList<Value> componentValues = new ArrayList<Value>();
        for (int i = 0; i < vectorSize; ++i) {
            componentValues.add(this.getComponentFunction(i).apply());
        }
        return new CompoundVectorValue(null, (List<Value>)componentValues, (DeterministicFunction)this);
    }

    @Override
    public Map<String, Value> getParams() {
        return this.params;
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.params.put(paramName, value);
        if (!VectorUtils.isVectorizedParameter(paramName, value, this.baseTypes)) {
            for (DeterministicFunction<T> componentFunction : this.componentFunctions) {
                componentFunction.setParam(paramName, value);
            }
        } else {
            for (int i = 0; i < this.componentFunctions.size(); ++i) {
                if (value instanceof CompoundVector) {
                    this.componentFunctions.get(i).setInput(paramName, ((CompoundVector)((Object)value)).getComponentValue(i));
                    continue;
                }
                this.componentFunctions.get(i).setInput(paramName, new SliceValue(i, value));
            }
        }
    }

    @Override
    public String getTypeName() {
        if (this.componentFunctions.size() > 1) {
            return "vector of " + NarrativeUtils.pluralize(this.componentFunctions.get(0).getTypeName());
        }
        return Generator.getReturnType(this.getClass()).getSimpleName();
    }

    @Override
    public String getName() {
        return this.componentFunctions.get(0).getName();
    }

    @Override
    public String codeString() {
        return Func.codeString(this.componentFunctions.get(0), this.getParams());
    }

    public Value getReplicatesValue() {
        for (Map.Entry<String, Value> entry : this.getParams().entrySet()) {
            Value replicatesValue;
            Generator paramGenerator = entry.getValue().getGenerator();
            if (paramGenerator == null || !this.isVectorizedParameter(entry.getKey())) continue;
            if (paramGenerator instanceof IID) {
                return ((IID)entry.getValue().getGenerator()).getReplicates();
            }
            if (paramGenerator instanceof VectorizedDistribution) {
                replicatesValue = ((VectorizedDistribution)paramGenerator).getReplicatesValue();
                if (replicatesValue == null) continue;
                return replicatesValue;
            }
            if (paramGenerator instanceof VectorizedFunction) {
                replicatesValue = ((VectorizedFunction)paramGenerator).getReplicatesValue();
                if (replicatesValue == null) continue;
                return replicatesValue;
            }
            VectorUtils.getReplicatesValue(paramGenerator, this.componentFunctions.size());
        }
        return null;
    }

    public boolean isVectorizedParameter(String paramName) {
        return VectorUtils.isVectorizedParameter(paramName, this.getParams().get(paramName), this.baseTypes);
    }

    public static void main(String[] args) {
        Value<Number> arg = new Value<Number>("arg", 1);
        Exp exp = new Exp(arg);
        HashMap<String, Value<Number[]>> params = new HashMap<String, Value<Number[]>>();
        params.put("arg", new Value<Number[]>("arg", new Number[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        Object[] initArgs = new Object[]{params.get("arg")};
        System.out.println(" vector match = " + ParserUtils.vectorMatch(Generator.getArguments(exp.getClass(), 0), initArgs));
        Constructor<?> constructor = exp.getClass().getConstructors()[0];
        VectorizedFunction v = new VectorizedFunction(constructor, Generator.getArguments(constructor), initArgs);
        Value<T[]> repValue = v.apply();
        Object[] rv = (Double[])repValue.value();
        System.out.println(Arrays.toString(rv));
    }

    public List<DeterministicFunction<T>> getComponentFunctions() {
        return this.componentFunctions;
    }

    @Override
    public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        if (value instanceof CompoundVectorValue) {
            CompoundVectorValue vrv = (CompoundVectorValue)value;
            StringBuilder builder = new StringBuilder();
            Generator generator = this.componentFunctions.get(0);
            Value v = vrv.getComponentValue(0);
            String inferenceNarrative = generator.getInferenceNarrative(v, unique, narrative);
            inferenceNarrative = inferenceNarrative.replaceAll("_0", narrative.subscript("i"));
            inferenceNarrative = inferenceNarrative.replaceAll("_\\{0}", narrative.subscript("i"));
            builder.append(inferenceNarrative);
            return builder.toString();
        }
        throw new RuntimeException("Expected CompoundVectorValue!");
    }

    @Override
    public String getNarrativeName(Value value) {
        String paramName = this.getParamName(value);
        Generator generator = this.componentFunctions.get(0);
        return generator.getNarrativeName(paramName);
    }
}

