/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions.datatype;

import jebl.evolution.sequences.SequenceType;
import lphy.evolution.datatype.Standard;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class StandardDatatypeFunction
extends DeterministicFunction<SequenceType> {
    public static final String numStatesParamName = "numStates";

    public StandardDatatypeFunction(@ParameterInfo(name="numStates", description="the number of distinct states in this data type.") Value<Integer> stateCount) {
        this.setParam(numStatesParamName, (Value)stateCount);
    }

    @Override
    @GeneratorInfo(name="standard", verbClause="is", narrativeName="the Standard data type", description="The Standard data type function. Takes a state count and produces a Standard data type with that number of states.")
    public Value<SequenceType> apply() {
        Value stateCountValue = this.getParams().get(numStatesParamName);
        int stateCount = (Integer)stateCountValue.value();
        return new Value<SequenceType>(null, new Standard(stateCount), this);
    }
}

