/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.functions.newickParser;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import lphy.core.functions.newickParser.NewickParser;
import lphy.core.functions.newickParser.NewickParserBaseVisitor;
import lphy.core.functions.newickParser.TreeParsingException;
import lphy.evolution.tree.TimeTreeNode;
import org.antlr.v4.runtime.tree.ParseTree;

public class NewickASTVisitor
extends NewickParserBaseVisitor<TimeTreeNode> {
    private int numberedNodeCount = 0;
    private double DEFAULT_LENGTH = 0.001;
    List<String> labels = new ArrayList<String>();

    @Override
    public TimeTreeNode visitTree(NewickParser.TreeContext ctx) {
        TimeTreeNode root = (TimeTreeNode)this.visit((ParseTree)ctx.node());
        root.sort();
        this.convertLengthToHeight(root);
        this.numberUnnumberedNodes(root);
        BitSet nodeNrSeen = new BitSet();
        for (TimeTreeNode leaf : root.getAllLeafNodes()) {
            if (leaf.getIndex() < 0) continue;
            if (nodeNrSeen.get(leaf.getIndex())) {
                throw new TreeParsingException("Duplicate taxon found: " + this.labels.get(leaf.getIndex()));
            }
            nodeNrSeen.set(leaf.getIndex());
        }
        return root;
    }

    private void processMetadata(TimeTreeNode node, NewickParser.MetaContext metaContext, boolean isLengthMeta) {
        Object metaDataString = "";
        for (int i = 0; i < metaContext.attrib().size(); ++i) {
            if (i > 0) {
                metaDataString = (String)metaDataString + ",";
            }
            metaDataString = (String)metaDataString + metaContext.attrib().get(i).getText();
        }
        for (NewickParser.AttribContext attribctx : metaContext.attrib()) {
            Object[] value;
            String key = attribctx.attribKey.getText();
            if (attribctx.attribValue().attribNumber() != null) {
                value = Double.parseDouble(attribctx.attribValue().attribNumber().getText());
            } else if (attribctx.attribValue().ASTRING() != null) {
                String stringValue = attribctx.attribValue().ASTRING().getText();
                if (stringValue.startsWith("\"") || stringValue.startsWith("'")) {
                    stringValue = stringValue.substring(1, stringValue.length() - 1);
                }
                value = stringValue;
            } else if (attribctx.attribValue().vector() != null) {
                try {
                    List<NewickParser.AttribValueContext> elementContexts = attribctx.attribValue().vector().attribValue();
                    Double[] arrayValues = new Double[elementContexts.size()];
                    for (int i = 0; i < elementContexts.size(); ++i) {
                        arrayValues[i] = Double.parseDouble(elementContexts.get(i).getText());
                    }
                    value = arrayValues;
                }
                catch (NumberFormatException ex) {
                    List<NewickParser.AttribValueContext> elementContexts = attribctx.attribValue().vector().attribValue();
                    String[] arrayValues = new String[elementContexts.size()];
                    for (int i = 0; i < elementContexts.size(); ++i) {
                        arrayValues[i] = elementContexts.get(i).getText();
                    }
                    value = arrayValues;
                }
            } else {
                throw new TreeParsingException("Encountered unknown metadata value.");
            }
            if (isLengthMeta) {
                node.setMetaData(key, value);
                continue;
            }
            node.setMetaData(key, value);
        }
    }

    @Override
    public TimeTreeNode visitNode(NewickParser.NodeContext ctx) {
        TimeTreeNode node = new TimeTreeNode((String)null, null);
        for (NewickParser.NodeContext ctxChild : ctx.node()) {
            node.addChild((TimeTreeNode)this.visit((ParseTree)ctxChild));
        }
        NewickParser.PostContext postCtx = ctx.post();
        if (postCtx.nodeMeta != null) {
            this.processMetadata(node, postCtx.nodeMeta, false);
        }
        if (postCtx.lengthMeta != null) {
            this.processMetadata(node, postCtx.lengthMeta, true);
        }
        if (postCtx.length != null) {
            node.setAge(Double.parseDouble(postCtx.length.getText()));
        } else {
            node.setAge(this.DEFAULT_LENGTH);
        }
        node.setIndex(-1);
        if (postCtx.label() != null) {
            node.setId(postCtx.label().getText());
            if (node.isLeaf()) {
                node.setIndex(this.getLabelIndex(postCtx.label().getText()));
                ++this.numberedNodeCount;
            }
        }
        return node;
    }

    private int getLabelIndex(String str) {
        for (int index = 0; index < this.labels.size(); ++index) {
            if (!str.equals(this.labels.get(index))) continue;
            return index;
        }
        this.labels.add(str);
        return this.labels.size() - 1;
    }

    private void convertLengthToHeight(TimeTreeNode root) {
        double totalHeight = this.convertLengthToHeight(root, 0.0);
        this.offset(root, -totalHeight);
    }

    private double convertLengthToHeight(TimeTreeNode node, double height) {
        double length = node.getAge();
        node.setAge(height - length);
        if (node.isLeaf()) {
            return node.getAge();
        }
        double minChildHeight = Double.POSITIVE_INFINITY;
        for (TimeTreeNode child : node.getChildren()) {
            minChildHeight = Math.min(minChildHeight, this.convertLengthToHeight(child, height - length));
        }
        return minChildHeight;
    }

    private void offset(TimeTreeNode node, double delta) {
        node.setAge(node.getAge() + delta);
        if (node.isLeaf() && node.getAge() < 0.0) {
            node.setAge(0.0);
        }
        if (!node.isLeaf()) {
            for (TimeTreeNode child : node.getChildren()) {
                this.offset(child, delta);
            }
        }
    }

    private void numberUnnumberedNodes(TimeTreeNode node) {
        if (node.isLeaf()) {
            return;
        }
        for (TimeTreeNode child : node.getChildren()) {
            this.numberUnnumberedNodes(child);
        }
        if (node.getIndex() < 0) {
            node.setIndex(this.numberedNodeCount);
        }
        ++this.numberedNodeCount;
    }
}

