/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.lightweight.GeneratorAdapter;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.core.lightweight.VectorizedGenerativeDistribution;
import lphy.core.lightweight.distributions.Beta;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class GenerativeDistributionAdapter<T>
extends GeneratorAdapter<T>
implements GenerativeDistribution<T> {
    public GenerativeDistributionAdapter(LGenerativeDistribution<T> baseDistribution, Map<String, Value> params) {
        super(baseDistribution, params);
    }

    @Override
    public RandomVariable<T> sample() {
        return this.sample(null);
    }

    @Override
    public RandomVariable<T> sample(String id) {
        return new RandomVariable(id, ((LGenerativeDistribution)this.baseDistribution).sample(), this);
    }

    @Override
    public Value<T> generate() {
        return this.sample();
    }

    public static void main(String[] args) {
        Beta beta = new Beta(1.0, 2.0);
        VectorizedGenerativeDistribution<Double> v = new VectorizedGenerativeDistribution<Double>(beta, null);
        TreeMap<String, Value> params = new TreeMap<String, Value>();
        params.put("alpha", new Value<Double[]>(null, new Double[]{200.0, 200.0, 200.0, 3.0, 3.0, 3.0}));
        params.put("beta", new Value<Double>(null, 2.0));
        long time = System.currentTimeMillis();
        Value<T[]> rbeta = null;
        for (int i = 0; i < 10000; ++i) {
            GenerativeDistributionAdapter<T[]> w = new GenerativeDistributionAdapter<T[]>(v, (Map<String, Value>)params);
            rbeta = w.generate();
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Elapsed time = " + (stopTime - time));
        System.out.println(Arrays.toString(rbeta.value()));
        System.out.println(Arrays.toString(beta.getClass().getConstructors()[0].getParameterTypes()));
    }
}

