/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.lightweight.LGenerator;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.Value;

public abstract class GeneratorAdapter<T>
implements Generator<T> {
    LGenerator<T> baseDistribution;
    Map<String, Value> params;

    public GeneratorAdapter(LGenerator<T> baseDistribution, Map<String, Value> params) {
        this.baseDistribution = baseDistribution;
        this.params = params;
        if (this.params == null) {
            this.params = new TreeMap<String, Value>();
        }
        this.setup();
    }

    void setup() {
        for (Map.Entry<String, Value> entry : this.params.entrySet()) {
            this.baseDistribution.setArgumentValue(entry.getKey(), entry.getValue().value());
        }
    }

    @Override
    public String getName() {
        return this.baseDistribution.getName();
    }

    @Override
    public Value<T> generate() {
        return new Value<T>(null, this.baseDistribution.generateRaw());
    }

    @Override
    public Map<String, Value> getParams() {
        return this.params;
    }

    @Override
    public String getUniqueId() {
        return null;
    }

    @Override
    public T value() {
        return this.baseDistribution.generateRaw();
    }
}

