/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lphy.core.lightweight.LGenerator;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GeneratorInfo;
import net.steppschuh.markdowngenerator.link.Link;
import net.steppschuh.markdowngenerator.list.UnorderedList;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.emphasis.BoldText;
import net.steppschuh.markdowngenerator.text.heading.Heading;

public interface LGenerativeDistribution<T>
extends LGenerator<T> {
    @Override
    default public boolean isRandomGenerator() {
        return true;
    }

    default public T sample() {
        return this.generateRaw();
    }

    default public double density(T value) {
        return Math.exp(this.logDensity(value));
    }

    default public double logDensity(T value) {
        return Math.log(this.density(value));
    }

    @Override
    default public T generateRaw() {
        return this.sample();
    }

    /*
     * WARNING - void declaration
     */
    public static String getLightweightGeneratorMarkdown(Class<? extends LGenerator> generatorClass) {
        GeneratorInfo generatorInfo = Generator.getGeneratorInfo(generatorClass);
        List<Argument> arguments = LGenerator.getArguments(generatorClass, 0);
        StringBuilder md = new StringBuilder();
        StringBuilder signature = new StringBuilder();
        signature.append(Generator.getGeneratorName(generatorClass)).append("(");
        int count = 0;
        for (Argument argument : arguments) {
            if (count > 0) {
                signature.append(", ");
            }
            signature.append(new Text((Object)argument.type.getSimpleName())).append(" ").append(new BoldText((Object)argument.name));
            ++count;
        }
        signature.append(")");
        md.append(new Heading((Object)signature.toString(), 2)).append("\n\n");
        if (generatorInfo != null) {
            md.append(generatorInfo.description()).append("\n\n");
        }
        if (arguments.size() > 0) {
            md.append(new Heading((Object)"Parameters", 3)).append("\n\n");
            ArrayList<Text> paramText = new ArrayList<Text>();
            for (Argument argument : arguments) {
                paramText.add(new Text((Object)(argument.type.getSimpleName() + " " + new BoldText((Object)argument.name) + " - " + argument.description)));
            }
            md.append(new UnorderedList(paramText));
        }
        md.append("\n\n");
        try {
            md.append(new Heading((Object)"Return type", 3)).append("\n\n");
            Class<?> returnTypeClass = generatorClass.getMethod("sample", new Class[0]).getReturnType();
            List<String> list = Collections.singletonList(returnTypeClass.getSimpleName());
            md.append(new UnorderedList(list)).append("\n\n");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Citation citation = Generator.getCitation(generatorClass);
        if (citation != null) {
            md.append(new Heading((Object)"Reference", 3)).append("\n\n");
            md.append(citation.value());
            if (citation.DOI().length() > 0) {
                void var7_15;
                String string = citation.DOI();
                if (!string.startsWith("http")) {
                    String string2 = "http://doi.org/" + string;
                }
                md.append(new Link((Object)var7_15, (String)var7_15));
            }
        }
        return md.toString();
    }
}

