/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.ParameterInfo;

public interface LGenerator<T> {
    public T generateRaw();

    public boolean isRandomGenerator();

    default public void setArgumentValue(Argument argument, Object val) {
        try {
            Method method = this.getSetMethod(argument);
            method.invoke((Object)this, val);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    default public Method getSetMethod(Argument argument) {
        try {
            return this.getClass().getMethod(argument.setMethodName(), argument.type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    default public void setArgumentValue(String name, Object val) {
        try {
            Method method = this.getClass().getMethod(Argument.setMethodName(name), val.getClass());
            method.invoke((Object)this, val);
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method method : methods = this.getClass().getMethods()) {
                if (!method.getName().equals(name)) continue;
                try {
                    method.invoke((Object)this, val);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    default public Object getArgumentValue(Argument argument) {
        try {
            Method method = this.getClass().getMethod(argument.getMethodName(), new Class[0]);
            return method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public List<Argument> getArguments() {
        return LGenerator.getArguments(this.getClass(), 0);
    }

    default public Argument getArgumentByName(String name) {
        List<Argument> arguments = this.getArguments();
        for (Argument arg : arguments) {
            if (!arg.name.equals(name)) continue;
            return arg;
        }
        return null;
    }

    public static Class<?> getReturnType(Class<LGenerator> c) {
        try {
            return c.getMethod("generateRaw", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Argument> getArguments(Class c, int constructorIndex) {
        System.out.println("Getting arguments for " + c);
        Constructor<?> constructor = c.getConstructors()[constructorIndex];
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        Object[] parameterTypes = constructor.getParameterTypes();
        System.out.println("  parameter types: " + Arrays.toString(parameterTypes));
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotations1;
            for (Annotation annotation : annotations1 = annotations[i]) {
                if (!(annotation instanceof ParameterInfo)) continue;
                arguments.add(new Argument(i, (ParameterInfo)annotation, (Class)parameterTypes[i]));
            }
        }
        return arguments;
    }
}

