/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.core.lightweight.VectorizedGenerator;
import lphy.core.lightweight.distributions.Beta;
import lphy.core.lightweight.distributions.Dirichlet;
import lphy.core.lightweight.distributions.DiscretizedGamma;
import lphy.core.lightweight.distributions.Exp;
import lphy.core.lightweight.distributions.Gamma;
import lphy.core.lightweight.distributions.LogNormal;
import lphy.core.lightweight.distributions.Normal;
import lphy.core.lightweight.distributions.Poisson;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.Generator;

public class VectorizedGenerativeDistribution<T>
extends VectorizedGenerator<T>
implements LGenerativeDistribution<T[]> {
    static Map<String, Set<Class<?>>> genDistDictionary;

    public VectorizedGenerativeDistribution(LGenerativeDistribution<T> baseDistribution, SortedMap<Argument, Object> argumentValues) {
        super(baseDistribution, argumentValues);
    }

    public static VectorizedGenerativeDistribution createVectorizedGenerativeDistribution(String name, Map<String, Object> params) {
        LGenerativeDistribution lwg = (LGenerativeDistribution)((Object)genDistDictionary.get(name));
        if (lwg == null) {
            throw new RuntimeException("Couldn't find generative distribution named: " + name);
        }
        SortedMap arguments = params.entrySet().stream().collect(Collectors.toMap(e -> lwg.getArgumentByName((String)e.getKey()), e -> e, (u, v) -> {
            throw new RuntimeException("should not happen: " + u + " --- map: " + v);
        }, TreeMap::new));
        return new VectorizedGenerativeDistribution(lwg, (SortedMap<Argument, Object>)arguments);
    }

    public static void main(String[] args) {
        Beta beta = new Beta(1.0, 2.0);
        TreeMap<Argument, Object> arguments = new TreeMap<Argument, Object>();
        arguments.put(beta.getArguments().get(0), new Double[]{200.0, 200.0, 200.0, 3.0, 3.0, 3.0});
        arguments.put(beta.getArguments().get(1), 2.0);
        VectorizedGenerativeDistribution<Double> v = new VectorizedGenerativeDistribution<Double>(beta, (SortedMap<Argument, Object>)arguments);
        Object[] rbeta = (Double[])v.generateRaw();
        System.out.println(Arrays.toString(rbeta));
        System.out.println(Arrays.toString(beta.getClass().getConstructors()[0].getParameterTypes()));
    }

    static {
        Class[] genClasses;
        genDistDictionary = new TreeMap();
        for (Class genClass : genClasses = new Class[]{Normal.class, LogNormal.class, Exp.class, Dirichlet.class, Gamma.class, DiscretizedGamma.class, Beta.class, Poisson.class}) {
            String name = Generator.getGeneratorName(genClass);
            Set genDistSet = genDistDictionary.computeIfAbsent(name, k -> new HashSet());
            genDistSet.add(genClass);
        }
    }
}

