/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lphy.core.lightweight.LGenerator;
import lphy.graphicalModel.Argument;

public abstract class VectorizedGenerator<T>
implements LGenerator<T[]> {
    Class<? extends LGenerator> baseGeneratorClass;
    LGenerator<T> baseGenerator;
    private SortedMap<Argument, Object> argumentValues;
    private SortedMap<String, Argument> argumentsByName = new TreeMap<String, Argument>();
    private List<Method> vectorizedSetMethods = new ArrayList<Method>();
    private List<Object> vectorizedArgumentValues = new ArrayList<Object>();
    int dim;

    public VectorizedGenerator(Class<? extends LGenerator> baseGeneratorClass, SortedMap<Argument, Object> argumentValues) {
        this.baseGeneratorClass = baseGeneratorClass;
        for (Argument arg : LGenerator.getArguments(baseGeneratorClass, 0)) {
            this.argumentsByName.put(arg.name, arg);
        }
        if (argumentValues == null) {
            this.argumentValues = new TreeMap<Argument, Object>();
        }
        this.setup();
    }

    public VectorizedGenerator(LGenerator<T> baseGenerator, SortedMap<Argument, Object> argumentValues) {
        this.baseGeneratorClass = baseGenerator.getClass();
        this.baseGenerator = baseGenerator;
        this.argumentValues = argumentValues;
        for (Argument arg : baseGenerator.getArguments()) {
            this.argumentsByName.put(arg.name, arg);
        }
        if (argumentValues == null) {
            this.argumentValues = new TreeMap<Argument, Object>();
        }
        this.setup();
    }

    void setup() {
        if (this.baseGenerator == null) {
            List<Argument> args = LGenerator.getArguments(this.baseGeneratorClass, 0);
            Object[] initArgs = new Object[args.size()];
            for (int i = 0; i < initArgs.length; ++i) {
                Argument arg = args.get(i);
                Object value = this.argumentValues.get(arg.name);
                initArgs[i] = VectorizedGenerator.isArrayOfType(value, arg.type) ? Array.get(value, 0) : value;
            }
        }
        this.vectorizedSetMethods.clear();
        this.vectorizedArgumentValues.clear();
        this.dim = 1;
        for (Map.Entry<Argument, Object> entry : this.argumentValues.entrySet()) {
            Argument arg = entry.getKey();
            Object value = entry.getValue();
            if (VectorizedGenerator.isArrayOfType(value, arg.type)) {
                int vectorSize = Array.getLength(value);
                if (this.dim == 1) {
                    this.dim = vectorSize;
                } else if (this.dim != vectorSize) {
                    throw new RuntimeException("Vector sizes do not match!");
                }
                this.vectorizedSetMethods.add(this.baseGenerator.getSetMethod(arg));
                this.vectorizedArgumentValues.add(value);
                Object input = Array.get(value, 0);
                this.baseGenerator.setArgumentValue(arg, input);
                continue;
            }
            this.baseGenerator.setArgumentValue(arg, value);
        }
    }

    @Override
    public boolean isRandomGenerator() {
        return this.baseGenerator.isRandomGenerator();
    }

    @Override
    public T[] generateRaw() {
        T first = this.baseGenerator.generateRaw();
        Object[] result = (Object[])Array.newInstance(first.getClass(), this.dim);
        result[0] = first;
        for (int i = 1; i < result.length; ++i) {
            for (int j = 0; j < this.vectorizedSetMethods.size(); ++j) {
                Object input = Array.get(this.vectorizedArgumentValues.get(j), i);
                try {
                    this.vectorizedSetMethods.get(j).invoke(this.baseGenerator, input);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                result[i] = this.baseGenerator.generateRaw();
            }
        }
        return result;
    }

    @Override
    public void setArgumentValue(Argument argument, Object val) {
        this.argumentValues.put(argument, val);
        this.setup();
    }

    @Override
    public void setArgumentValue(String argument, Object val) {
        this.argumentValues.put((Argument)this.argumentsByName.get(argument), val);
        this.setup();
    }

    @Override
    public Object getArgumentValue(Argument argument) {
        return this.argumentValues.get(argument);
    }

    static boolean isArrayOfType(Object maybeArray, Class ofType) {
        if (maybeArray.getClass().isArray()) {
            Object firstElement = Array.get(maybeArray, 0);
            return firstElement.getClass() == ofType;
        }
        return false;
    }
}

