/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.random.RandomGenerator;

public class Bernoulli
implements LGenerativeDistribution<Boolean> {
    Double p;
    RandomGenerator randomGenerator;

    public Bernoulli(@ParameterInfo(name="p", description="the probability of success.") Double p) {
        this.p = p;
        this.randomGenerator = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Bernoulli", description="The coin toss distribution. With true (heads) having probability p.")
    public Boolean sample() {
        return this.randomGenerator.nextDouble() <= this.p;
    }

    @Override
    public double density(Boolean i) {
        return i != false ? this.p : 1.0 - this.p;
    }

    public void setP(Double p) {
        this.p = p;
    }

    public Double getP() {
        return this.p;
    }
}

