/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.BetaDistribution;

public class Beta
implements LGenerativeDistribution<Double> {
    private Number alpha;
    private Number beta;
    BetaDistribution betaDistribution;

    public Beta(@ParameterInfo(name="alpha", description="the first shape parameter.") Number alpha, @ParameterInfo(name="beta", description="the second shape parameter.") Number beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.setup();
    }

    void setup() {
        this.betaDistribution = new BetaDistribution(this.alpha.doubleValue(), this.beta.doubleValue());
    }

    public Number getAlpha() {
        return this.alpha;
    }

    public Number getBeta() {
        return this.beta;
    }

    public void setAlpha(Number alpha) {
        this.alpha = alpha;
        this.setup();
    }

    public void setBeta(Number beta) {
        this.beta = beta;
        this.setup();
    }

    @Override
    @GeneratorInfo(name="Beta", description="The beta probability distribution.")
    public Double sample() {
        return this.betaDistribution.sample();
    }
}

