/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.BinomialDistribution;

public class Binomial
implements LGenerativeDistribution<Integer> {
    private Double p;
    private Integer n;
    BinomialDistribution binomial;

    public Binomial(@ParameterInfo(name="prob", description="the probability of a success.") Double p, @ParameterInfo(name="n", description="number of trials.") Integer n) {
        this.p = p;
        this.n = n;
        this.setup();
    }

    private void setup() {
        this.binomial = new BinomialDistribution(this.n.intValue(), this.p.doubleValue());
    }

    @Override
    @GeneratorInfo(name="Binomial", description="The binomial distribution of x successes in n trials given probability p of success of a single trial.")
    public Integer sample() {
        return this.binomial.sample();
    }

    @Override
    public double density(Integer i) {
        return this.binomial.probability(i.intValue());
    }

    void setP(Double p) {
        if (!this.p.equals(p)) {
            this.p = p;
            this.setup();
        }
    }

    void setN(Integer n) {
        if (!this.n.equals(n)) {
            this.n = n;
            this.setup();
        }
    }

    Integer getN() {
        return this.n;
    }

    Double getP() {
        return this.p;
    }

    public String toString() {
        return this.getName();
    }
}

