/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.random.RandomGenerator;

public class Categorical
implements LGenerativeDistribution<Integer> {
    Double[] probs;
    RandomGenerator random;

    public Categorical(@ParameterInfo(name="p", description="the probability distribution over integer states 1 to K.") Double[] probs) {
        this.probs = probs;
        this.random = Utils.getRandom();
    }

    @Override
    public Integer sample() {
        return Categorical.sample(this.probs, this.random);
    }

    public static int sample(Double[] p, RandomGenerator random) {
        double U = random.nextDouble();
        double sum = p[0];
        int i = 0;
        while (U > sum) {
            sum += p[i + 1].doubleValue();
            ++i;
        }
        return i;
    }

    Double[] getProbs() {
        return this.probs;
    }

    void setProbs(Double[] probs) {
        this.probs = probs;
    }
}

