/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class Cauchy
implements LGenerativeDistribution<Double> {
    private Double mean;
    private Double scale;
    private RandomGenerator random;
    CauchyDistribution cauchyDistribution;

    public Cauchy(@ParameterInfo(name="mean", description="the mean of the Cauchy distribution.") Double mean, @ParameterInfo(name="scale", description="the scale of the Cauchy distribution.") Double scale) {
        this.mean = mean;
        if (mean == null) {
            throw new IllegalArgumentException("The mean value can't be null!");
        }
        this.scale = scale;
        if (scale == null) {
            throw new IllegalArgumentException("The scale value can't be null!");
        }
        this.random = Utils.getRandom();
        this.constructCauchyDistribution();
    }

    @Override
    @GeneratorInfo(name="Cauchy", description="The Cauchy probability distribution.")
    public Double sample() {
        this.constructCauchyDistribution();
        return this.cauchyDistribution.sample();
    }

    @Override
    public double density(Double x) {
        return this.cauchyDistribution.density(x.doubleValue());
    }

    public Double getMean() {
        return this.mean;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    private void constructCauchyDistribution() {
        double mean = this.mean;
        double sc = this.scale;
        this.cauchyDistribution = new CauchyDistribution(mean, sc);
    }

    public String toString() {
        return this.getName();
    }
}

