/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;

public class Dirichlet
implements LGenerativeDistribution<Double[]> {
    private Double[] concentration;

    public Dirichlet(@ParameterInfo(name="conc", description="the concentration parameters of a Dirichlet distribution.") Double[] concentration) {
        this.concentration = concentration;
    }

    @Override
    @GeneratorInfo(name="Dirichlet", description="The dirichlet probability distribution.")
    public Double[] sample() {
        int i;
        Double[] dirichlet = new Double[this.concentration.length];
        double sum = 0.0;
        for (i = 0; i < dirichlet.length; ++i) {
            double val = Utils.randomGamma(this.concentration[i], 1.0);
            dirichlet[i] = val;
            sum += val;
        }
        i = 0;
        while (i < dirichlet.length) {
            Double[] doubleArray = dirichlet;
            int n = i++;
            Double.valueOf(doubleArray[n] / sum);
        }
        return dirichlet;
    }

    @Override
    public double density(Double d) {
        return 0.0;
    }

    public Double[] getConcentration() {
        return this.concentration;
    }

    public void setConcentration(Double[] concentration) {
        this.concentration = concentration;
    }

    public String toString() {
        return this.getName();
    }
}

