/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.GammaDistribution;

@Deprecated
public class DiscretizedGamma
implements LGenerativeDistribution<Double[]> {
    private Double shape;
    private Integer ncat;
    private Integer reps;
    GammaDistribution gammaDistribution;
    double[] rates;

    public DiscretizedGamma(@ParameterInfo(name="shape", description="the shape of the discretized gamma distribution.") Double shape, @ParameterInfo(name="ncat", description="the number of bins in the discretization.") Integer ncat, @ParameterInfo(name="reps", description="the number of iid samples to produce.", optional=true) Integer reps) {
        this.shape = shape;
        if (shape == null) {
            throw new IllegalArgumentException("The shape value can't be null!");
        }
        this.ncat = ncat;
        this.reps = reps;
        this.constructGammaDistribution();
    }

    @Override
    @GeneratorInfo(name="G", description="The discretized gamma probability distribution with mean = 1.")
    public Double[] sample() {
        this.constructGammaDistribution();
        int n = 1;
        if (this.reps != null) {
            n = this.reps;
        }
        Double[] x = new Double[n];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.rates[Utils.getRandom().nextInt(this.rates.length)];
        }
        return x;
    }

    @Override
    public double logDensity(Double[] x) {
        throw new UnsupportedOperationException("TODO");
    }

    public Double getShape() {
        return this.shape;
    }

    public void setShape(Double shape) {
        this.shape = shape;
    }

    public Integer getNcat() {
        return this.ncat;
    }

    public void setNcat(Integer ncat) {
        this.ncat = ncat;
    }

    public Integer getReps() {
        return this.reps;
    }

    public void setReps(Integer reps) {
        this.reps = reps;
    }

    private void constructGammaDistribution() {
        double sh = this.shape;
        this.gammaDistribution = new GammaDistribution(sh, 1.0 / sh);
        this.rates = new double[this.ncat.intValue()];
        for (int i = 0; i < this.rates.length; ++i) {
            double q = (2.0 * (double)i + 1.0) / (2.0 * (double)this.rates.length);
            this.rates[i] = this.gammaDistribution.inverseCumulativeProbability(q);
        }
    }

    public String toString() {
        return this.getName();
    }
}

