/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.random.RandomGenerator;

public class Exp
implements LGenerativeDistribution<Double> {
    private Double rate;
    private RandomGenerator random;

    public Exp(@ParameterInfo(name="rate", description="the rate of an exponential distribution.") Double rate) {
        this.rate = rate;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Exp", description="The exponential probability distribution.")
    public Double sample() {
        return -Math.log(this.random.nextDouble()) / this.rate;
    }

    @Override
    public double density(Double aDouble) {
        return 0.0;
    }

    public Double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public String toString() {
        return this.getName();
    }
}

