/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.GammaDistribution;

public class Gamma
implements LGenerativeDistribution<Double> {
    private Double shape;
    private Double scale;
    GammaDistribution gammaDistribution;

    public Gamma(@ParameterInfo(name="shape", description="the shape of the distribution.") Double shape, @ParameterInfo(name="scale", description="the scale of the distribution.") Double scale) {
        this.shape = shape;
        if (shape == null) {
            throw new IllegalArgumentException("The shape value can't be null!");
        }
        this.scale = scale;
        if (scale == null) {
            throw new IllegalArgumentException("The scale value can't be null!");
        }
        this.constructGammaDistribution();
    }

    @Override
    @GeneratorInfo(name="Gamma", description="The gamma probability distribution.")
    public Double sample() {
        this.constructGammaDistribution();
        return this.gammaDistribution.sample();
    }

    public Double getShape() {
        return this.shape;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setShape(Double shape) {
        this.shape = shape;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    @Override
    public double density(Double x) {
        return this.gammaDistribution.density(x.doubleValue());
    }

    private void constructGammaDistribution() {
        double sh = this.shape;
        double sc = this.scale;
        this.gammaDistribution = new GammaDistribution(sh, sc);
    }

    public String toString() {
        return this.getName();
    }
}

